﻿var importSampleHistory = {
    sampleId: 0,
    datatable: null,
    refreshDataTable: function () {
        importSampleHistory.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-sampleHistoryTable").a4datatable({
            generateTableStructure: true,
            displayColumnSelector: false,
            advancedFilter: false,
            ajaxAction: a4.getAction("GetImportSampleHistory", "Distribute", "Survey", { sampleId: importSampleHistory.sampleId }),
            columns: [
                { "Name": "FileName", "Title": resources.Filename, "Data": "FileName" },
                { "Name": "CaseCount", "Title": resources.CaseCount, "Data": "CaseCount", "Type": "numeric" },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum", "Type": "enum", "EnumType": "TaskStatus" },
                { "Name": "ExecutionTime", "Title": resources.DateTime, "Data": "ExecutionTime", "Type": "date" },
                { "Name": "Message", "Title": resources.Message, "Data": "Message", "Width": "50%", "Sortable": false }
            ],
            defaultSorting: { Column: "ExecutionTime", Ascending: false },
            displayContextMenu: true,
            displaySelectRow: false,
            displayContextMenu: false,
            displaySearchBox: false,
            contextMenuItems: [],
            contextMenuClick: function (event, data) { },
            toolBarItems: [],
            toolBarClick: function (event, data) { }
        });
    }
}

$(document).ready(function () {
    if ($(".v-sampleHistoryTable").length > 0) {
        importSampleHistory.sampleId = $("#SampleId").val();
        importSampleHistory.initializeDataTable();
    }
});


